package org.umk.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;

class SzescianGL {
	private final IntBuffer mBuforWierzcholka;
	
	// tekstura
	private final IntBuffer mBuforTekstury;
	
	public SzescianGL() {
		int jeden = 65536;
		int pol = jeden / 2;
		int[] wierzcholki = {
				// ciana przednia
				-pol, -pol, pol, 
				pol, -pol, pol, 
				-pol, pol, pol, 
				pol, pol, pol,
				// ciana tylnia
				-pol, -pol, -pol, 
				-pol, pol, -pol, 
				pol, -pol, -pol, 
				pol, pol, -pol, 
				// ciana lewa
				-pol, -pol, pol, 
				-pol, pol, pol, 
				-pol, -pol, -pol, 
				-pol, pol, -pol, 
				// ciana prawa
				pol, -pol, -pol, 
				pol, pol, -pol, 
				pol, -pol, pol, 
				pol, pol, pol, 
				// szczyt
				-pol, pol, pol, 
				pol, pol, pol, 
				-pol, pol, -pol, 
				pol, pol, -pol, 
				// spd
				-pol, -pol, pol, 
				-pol, -pol, -pol, 
				pol, -pol, pol, 
				pol, -pol, -pol, 
		};
		
		ByteBuffer vbb = ByteBuffer.allocateDirect(wierzcholki.length * 4);
		vbb.order(ByteOrder.nativeOrder());
		mBuforWierzcholka = vbb.asIntBuffer();
		mBuforWierzcholka.put(wierzcholki);
		mBuforWierzcholka.position(0);
		
		// tekstura
		int[] wspolrzedneTekstury = {
				// ciana przednia
				0, jeden, jeden, jeden, 0, 0, jeden, 0,
				// ciana tylnia
				jeden, jeden, jeden, 0, 0, jeden, 0, 0,
				// ciana lewa
				jeden, jeden, jeden, 0, 0, jeden, 0, 0,
				// ciana prawa
				jeden, jeden, jeden, 0, 0, jeden, 0, 0,
				// szczyt
				jeden, 0, 0, 0, jeden, jeden, 0, jeden,
				// spd
				0, 0, 0, jeden, jeden, 0, jeden, jeden, 
		};
		
		ByteBuffer tbb = ByteBuffer.allocateDirect(wspolrzedneTekstury.length * 4);
		tbb.order(ByteOrder.nativeOrder());
		mBuforTekstury = tbb.asIntBuffer();
		mBuforTekstury.put(wspolrzedneTekstury);
		mBuforTekstury.position(0);
	}
	
	static void wczytajTeksture(GL10 gl, Context kontekst, int zasob) {
		Bitmap bmp = BitmapFactory.decodeResource(
				kontekst.getResources(), zasob);
		GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bmp, 0);
		gl.glTexParameterx(GL10.GL_TEXTURE_2D, 
				GL10.GL_TEXTURE_MIN_FILTER, GL10.GL_LINEAR);
		gl.glTexParameterx(GL10.GL_TEXTURE_2D, 
				GL10.GL_TEXTURE_MAG_FILTER, GL10.GL_LINEAR);
	}
	
	public void rysuj(GL10 gl) {
		
		// tekstura ->
		gl.glEnable(GL10.GL_TEXTURE_2D);
		gl.glTexCoordPointer(2, GL10.GL_FIXED, 0, mBuforTekstury);
		// <- tekstura
		
		gl.glVertexPointer(3, GL10.GL_FIXED, 0, mBuforWierzcholka);
		
		gl.glColor4f(1, 1, 1, 1);
		gl.glNormal3f(0, 0, 1);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 0, 4);
		gl.glNormal3f(0, 0, -1);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 4, 4);
		
		gl.glColor4f(1, 1, 1, 1);
		gl.glNormal3f(-1, 0, 0);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 8, 4);
		gl.glNormal3f(1, 0, 0);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 12, 4);
		
		gl.glColor4f(1, 1, 1, 1);
		gl.glNormal3f(0, 1, 0);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 16, 4);
		gl.glNormal3f(0, -1, 0);
		gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 20, 4);
	}
}
